<?php

use App\Http\Controllers\InformationController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SitelinkController;
use App\Http\Controllers\UserController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

    Route::post('/register', [UserController::class, 'register']);
    Route::post('/login', [UserController::class, 'login']);

Route::prefix('v1')->group(function () {

    Route::get('/site', [SitelinkController::class, 'index']);
    Route::post('/sitelink', [SitelinkController::class, 'store']);
    Route::delete('/sitelink/{sitelink}', [SitelinkController::class, 'destroy']);

    // Data Store Route
    Route::get('/info', [InformationController::class, 'index']);
    Route::post('/info/store', [InformationController::class, 'storeInformation']);
    Route::post('/info/update-gcode', [InformationController::class, 'updateGcode']);
    Route::post('/info/update-status', [InformationController::class, 'updateStatus']);
    Route::post('/info/update-code', [InformationController::class, 'updateCode']);
    Route::post('/info/update-passcode', [InformationController::class, 'updatePassCode']);
    Route::get('/info/status', [InformationController::class, 'getStatus']);
    Route::delete('/info/{id}', [InformationController::class, 'deleteInfo']);
});
