import { Link, router, usePage } from "@inertiajs/react";
import { House, Link as LinkIcon, Mail } from "lucide-react";


const Sidebar = () => {

    const { url } = usePage();

    const activeClass = "bg-slate-800";
    const normalClass = "hover:bg-slate-600";

    return (
        <aside className="w-64 h-screen bg-slate-900 text-white flex flex-col">
            {/* Logo */}
            <div className="p-5 text-2xl font-bold border-b border-slate-700">
                LOGO
            </div>

            {/* Menu */}
            <nav className="flex-1 p-4 space-y-2">
                <Link href="/"
                    className={`block p-3 rounded-lg items-center ${url === "/" ? activeClass : normalClass}`}
                >
                    <House size={20} className="inline-block mr-2 -mt-1" />
                    Dashboard
                </Link>
                <Link href="/information"
                    className={`block p-3 rounded-lg ${url.startsWith("/information") ? activeClass : normalClass}`}
                >
                    <Mail size={20} className="inline-block mr-2 -mt-1" />
                    Information
                </Link >
                <Link href="/links"
                    className={`block p-3 rounded-lg ${url.startsWith("/links") ? activeClass : normalClass}`}
                >
                    <LinkIcon size={20} className="inline-block mr-2 -mt-1" />
                    Link
                </Link>
            </nav>

            {/* Bottom Item */}
            <div className="p-4 border-t border-slate-700">
                <button
                    onClick={() => router.post('/logout')}
                    className="w-full bg-red-500 py-2 rounded-lg">
                    Logout
                </button>
            </div>
        </aside>
    );
};

export default Sidebar;
