
const Loading = () => {
    return (
        <div>
            {/* Header */}
            <div className="flex items-center justify-between mb-6 border-b border-gray-200">
                <div className="h-8 w-48 bg-gray-300 rounded animate-pulse"></div>
                <div className="h-10 w-32 bg-gray-300 rounded animate-pulse"></div>
            </div>

            {/* Table Container */}
            <div className="bg-white rounded-2xl shadow-md border border-gray-100 overflow-hidden">
                <div className="overflow-x-auto">
                    <table className="w-full text-sm">
                        <thead>
                            <tr className="text-gray-500 text-left bg-gray-50 uppercase border-b border-gray-200">
                                <th className="px-6 py-3">ID</th>
                                <th className="px-6 py-3">Name</th>
                                <th className="px-6 py-3">URL</th>
                                <th className="px-6 py-3 text-right">Actions</th>
                            </tr>
                        </thead>

                        <tbody className="divide-y divide-gray-100">
                            {Array(5)
                                .fill(0)
                                .map((_, i) => (
                                    <tr key={i} className="hover:bg-gray-50 transition">
                                        <td className="px-6 py-4">
                                            <div className="h-4 w-8 bg-gray-300 rounded animate-pulse"></div>
                                        </td>

                                        <td className="px-6 py-4">
                                            <div className="h-4 w-32 bg-gray-300 rounded animate-pulse"></div>
                                        </td>

                                        <td className="px-6 py-4">
                                            <div className="h-4 w-48 bg-gray-300 rounded animate-pulse"></div>
                                        </td>

                                        <td className="px-6 py-4 text-right space-x-2 flex justify-end">
                                            <div className="h-6 w-16 bg-yellow-300 rounded animate-pulse"></div>
                                            <div className="h-6 w-16 bg-gray-300 rounded animate-pulse"></div>
                                            <div className="h-6 w-16 bg-blue-300 rounded animate-pulse"></div>
                                            <div className="h-6 w-16 bg-red-300 rounded animate-pulse"></div>
                                        </td>
                                    </tr>
                                ))}
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    )
}

export default Loading

