
import { Computer, Smartphone } from 'lucide-react';
import { Area, AreaChart, Bar, BarChart, CartesianGrid, Legend, Tooltip, XAxis, YAxis } from 'recharts';

const ItemsCard = () => {

    const data = [
        {
            name: 'Page A',
            uv: 4000,
            pv: 2400,
            amt: 2400,
        },
        {
            name: 'Page B',
            uv: 3000,
            pv: 1398,
            amt: 2210,
        },
        {
            name: 'Page C',
            uv: 2000,
            pv: 9800,
            amt: 2290,
        },
        {
            name: 'Page D',
            uv: 2780,
            pv: 3908,
            amt: 2000,
        },
    ];

    return (
        <div className="grid md:grid-cols-4 gap-6">
            <div className="bg-white p-6 rounded-xl shadow">
                <div className="flex items-center gap-2" >
                    <Computer className="text-amber-800" />
                    <h2 className="font-medium uppercase text-amber-800" >Total Click Computer</h2>
                </div>
                <AreaChart
                    style={{ width: '100%', maxWidth: '600px', maxHeight: '50vh', aspectRatio: 1.618 }}
                    responsive
                    data={data}
                    margin={{
                        top: 20,
                        right: 0,
                        left: 0,
                        bottom: 0,
                    }}
                    onContextMenu={(_, e) => e.preventDefault()}
                >
                    <CartesianGrid strokeDasharray="3 3" />
                    <XAxis dataKey="name" />
                    <YAxis width="auto" />
                    <Tooltip />
                    <Area type="monotone" dataKey="uv" stroke="#8884d8" fill="#8884d8" />

                </AreaChart>

            </div>
            <div className="bg-white p-6 rounded-xl shadow">
                <div className="flex items-center gap-2 mb-5" >
                    <Smartphone className="text-amber-800" />
                    <h2 className="font-medium uppercase text-amber-800" >Total Click Phone</h2>
                </div>
                <BarChart
                    style={{ width: '100%', maxWidth: '700px', maxHeight: '50vh', aspectRatio: 1.618 }}
                    responsive
                    data={data}
                    margin={{
                        top: 5,
                        right: 0,
                        left: 0,
                        bottom: 5,
                    }}
                >
                    <CartesianGrid strokeDasharray="3 3" />
                    <XAxis dataKey="name" />
                    <YAxis width="auto" />
                    <Tooltip />
                    <Legend />
                    <Bar dataKey="pv" fill="#8884d8" activeBar={{ fill: 'pink', stroke: 'blue' }} radius={[10, 10, 0, 0]} />
                    <Bar dataKey="uv" fill="#82ca9d" activeBar={{ fill: 'gold', stroke: 'purple' }} radius={[10, 10, 0, 0]} />
                </BarChart>
            </div>
             <div className="bg-white p-6 rounded-xl shadow">
                <div className="flex items-center gap-2" >
                    <Computer className="text-amber-800" />
                    <h2 className="font-medium uppercase text-amber-800" >Total Click Computer</h2>
                </div>
                <AreaChart
                    style={{ width: '100%', maxWidth: '600px', maxHeight: '50vh', aspectRatio: 1.618 }}
                    responsive
                    data={data}
                    margin={{
                        top: 20,
                        right: 0,
                        left: 0,
                        bottom: 0,
                    }}
                    onContextMenu={(_, e) => e.preventDefault()}
                >
                    <CartesianGrid strokeDasharray="3 3" />
                    <XAxis dataKey="name" />
                    <YAxis width="auto" />
                    <Tooltip />
                    <Area type="monotone" dataKey="uv" stroke="#8884d8" fill="#8884d8" />

                </AreaChart>

            </div>
            <div className="bg-white p-6 rounded-xl shadow">
                <div className="flex items-center gap-2 mb-5" >
                    <Smartphone className="text-amber-800" />
                    <h2 className="font-medium uppercase text-amber-800" >Total Click Phone</h2>
                </div>
                <BarChart
                    style={{ width: '100%', maxWidth: '700px', maxHeight: '50vh', aspectRatio: 1.618 }}
                    responsive
                    data={data}
                    margin={{
                        top: 5,
                        right: 0,
                        left: 0,
                        bottom: 5,
                    }}
                >
                    <CartesianGrid strokeDasharray="3 3" />
                    <XAxis dataKey="name" />
                    <YAxis width="auto" />
                    <Tooltip />
                    <Legend />
                    <Bar dataKey="pv" fill="#8884d8" activeBar={{ fill: 'pink', stroke: 'blue' }} radius={[10, 10, 0, 0]} />
                    <Bar dataKey="uv" fill="#82ca9d" activeBar={{ fill: 'gold', stroke: 'purple' }} radius={[10, 10, 0, 0]} />
                </BarChart>
            </div>
        </div>
    )
}

export default ItemsCard

