import { router } from '@inertiajs/react';
import { useForm } from "react-hook-form";


const Login = () => {
    const {
        register,
        handleSubmit,
        formState: { errors },
    } = useForm();



    const onSubmitForm = (data) => {
        router.post('/login', data, {
            onSuccess: () => {
                // Login successful হলে backend redirect করবে
                router.visit("/")
            },
            onError: (errors) => {
                console.log(errors);
            }
        });
    };



    return (
        <div className="min-h-screen bg-gray-100 flex items-center justify-center px-4">
            {/* Card */}
            <div className="w-full max-w-md bg-white rounded-2xl shadow-sm p-6 sm:p-8">
                {/* Header */}
                <div className="text-center mb-8">
                    <h1 className="text-2xl sm:text-3xl font-semibold text-gray-800">
                        Welcome Back 👋
                    </h1>
                    <p className="text-gray-500 mt-2 text-sm">
                        Sign in to continue to your account
                    </p>
                </div>

                {/* Form */}
                <form className="space-y-5" onSubmit={handleSubmit(onSubmitForm)} errors={errors} >
                    {/* Email */}
                    <div>
                        <label className="block text-sm text-gray-600 mb-1">
                            Email address
                        </label>
                        <input
                            type="email"
                            placeholder="you@example.com"
                            className="w-full border border-gray-300 rounded-lg px-4 py-2.5 outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                            {...register("email", { required: "Email is required" })}
                        />
                    </div>

                    {/* Password */}
                    <div>
                        <label className="block text-sm text-gray-600 mb-1">
                            Password
                        </label>
                        <input
                            type="password"
                            placeholder="••••••••"
                            className="w-full border border-gray-300 rounded-lg px-4 py-2.5 outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                            {...register("password", { required: "Password is required" })}
                        />
                    </div>

                    {/* Options */}
                    <div className="flex items-center justify-between text-sm">
                        <label className="flex items-center gap-2 text-gray-600">
                            <input
                                type="checkbox"
                                className="accent-blue-600"
                            />
                            Remember me
                        </label>

                        <button
                            type="button"
                            className="text-blue-600 hover:underline"
                        >
                            Forgot password?
                        </button>
                    </div>

                    {/* Error */}
                    {errors.email && (
                        <p className="text-red-500 text-sm mt-2">
                            {errors.email.message}
                        </p>
                    )}
                    {errors.password && (
                        <p className="text-red-500 text-sm mt-2">
                            {errors.password.message}
                        </p>
                    )}

                    {/* Button */}
                    <button
                        type="submit"
                        className="w-full bg-blue-600 text-white py-2.5 rounded-lg font-medium hover:bg-blue-700 transition"
                    >
                        Sign In
                    </button>
                </form>

                {/* Footer */}
                <p className="text-center text-sm text-gray-500 mt-6">
                    Don’t have an account?
                    <span className="text-blue-600 ml-1 cursor-pointer hover:underline">
                        Create one
                    </span>
                </p>
            </div>
        </div>
    );
};

export default Login;
