import { Action, Dispatch, Store } from '@reduxjs/toolkit';
import { optionsReducer } from './optionsSlice';
import { tooltipReducer } from './tooltipSlice';
import { chartDataReducer } from './chartDataSlice';
import { chartLayoutReducer } from './layoutSlice';
import { cartesianAxisReducer } from './cartesianAxisSlice';
import { graphicalItemsReducer } from './graphicalItemsSlice';
import { referenceElementsReducer } from './referenceElementsSlice';
import { brushReducer } from './brushSlice';
import { legendReducer } from './legendSlice';
import { rootPropsReducer } from './rootPropsSlice';
import { polarAxisReducer } from './polarAxisSlice';
import { polarOptionsReducer } from './polarOptionsSlice';
import { errorBarReducer } from './errorBarSlice';
import { zIndexReducer } from './zIndexSlice';
export type RechartsRootState = {
    brush: ReturnType<typeof brushReducer>;
    cartesianAxis: ReturnType<typeof cartesianAxisReducer>;
    chartData: ReturnType<typeof chartDataReducer>;
    errorBars: ReturnType<typeof errorBarReducer>;
    graphicalItems: ReturnType<typeof graphicalItemsReducer>;
    layout: ReturnType<typeof chartLayoutReducer>;
    legend: ReturnType<typeof legendReducer>;
    options: ReturnType<typeof optionsReducer>;
    polarAxis: ReturnType<typeof polarAxisReducer>;
    polarOptions: ReturnType<typeof polarOptionsReducer>;
    referenceElements: ReturnType<typeof referenceElementsReducer>;
    rootProps: ReturnType<typeof rootPropsReducer>;
    tooltip: ReturnType<typeof tooltipReducer>;
    zIndex: ReturnType<typeof zIndexReducer>;
};
export declare const createRechartsStore: (preloadedState?: Partial<RechartsRootState>, chartName?: string) => Store<RechartsRootState>;
export type AppDispatch = Dispatch<Action>;
