<?php

namespace App\Http\Controllers;

use App\Models\Sitelink;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class SitelinkController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // Get the all link
        $url = Sitelink::all();

        return response()->json([
            'status' => true,
            'data' => $url
        ], 200);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // validation request
        $validated = $request->validate([
            'name' => 'required|string',
            'site_url' => 'required|url'
        ]);

        try {
            $sitelink = Sitelink::create($validated);

            return response()->json([
                'status' => true,
                'message' => 'Sitelink created successfully',
                'data' => $sitelink
            ], 201);
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong',
            ], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Sitelink $sitelink)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Sitelink $sitelink)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Sitelink $sitelink)
    {
        //
        try {
            $sitelink->delete();
            return response()->json([
                'status' => true,
                'message' => 'Sitelink deleted successfully'
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'message' => 'Failed to delete sitelink'
            ], 500);
        }
    }
}
